// Formatear número con comas
const formatNumber = (num) => {
    if (num < 10000) {
      return num;
    }
    return num.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
  };
  
  // Manejar el cambio del slider
  const handleSliderChange = (e) => {
    const sliderValue = e.target.value;
    document.querySelector('.slider-value').textContent = `$${formatNumber(sliderValue)} USD`;
  };
  
  // Agregar el listener al slider una vez que el documento esté cargado
  document.addEventListener('DOMContentLoaded', () => {
    const priceSlider = document.getElementById('priceSlider');
    
    // Inicializar el valor formateado
    document.querySelector('.slider-value').textContent = `$${formatNumber(priceSlider.value)} USD`;
  
    // Escuchar cambios en el slider
    priceSlider.addEventListener('input', handleSliderChange);
  });
  